#include "bundlemgr.h"
#include "bundlemgr_impl.h"

namespace RUNES {


// コンストラクタ
BundleManager::BundleManager(const std::string& bundles_dir)
{
	// XXX: 例外処理？
	m_impl = new BundleManagerIMPL(bundles_dir);
}


// デストラクタ
BundleManager::~BundleManager()
{
	delete m_impl;
}


// public:
void BundleManager::initialize(void)
{
	return m_impl->initialize();
}

const Bundle* BundleManager::find(const std::string& name) const
{
	return m_impl->find(name);
}

const std::string& BundleManager::getBaseDir(void) const
{
	return m_impl->getBaseDir();
}

const std::list<const Bundle*> BundleManager::getList(void) const
{
	return m_impl->getList();
}

void BundleManager::show(void) const
{
	return m_impl->show();
}


}  // namespace RUNES
