#ifndef __BUNDLEMGR_H_INCLUDED
#define __BUNDLEMGR_H_INCLUDED 1

#include <string>
#include <list>
#include <boost/utility.hpp>

namespace RUNES {


class Bundle;
class BundleManagerIMPL;


class BundleManager : private boost::noncopyable {
public:
	explicit BundleManager(const std::string& bundles_dir);
	~BundleManager();
public:
	void initialize(void);
public:
	const Bundle* find(const std::string& name) const;
	const std::string& getBaseDir(void) const;
	const std::list<const Bundle*> getList(void) const;
	void show(void) const;
private:
	BundleManagerIMPL* m_impl;
private:
	BundleManager();
};


}  // namespace RUNES

#endif /* bundlemgr.h */
