#ifndef __BUMDLEMGR_IMPL_H_INCLUDED
#define __BUNDLEMGR_IMPL_H_INCLUDED 1

#include <string>
#include <list>
#include <map>

namespace RUNES {


class Bundle;

class BundleManagerIMPL {
public:
	explicit BundleManagerIMPL(const std::string& bundles_dir);
	~BundleManagerIMPL();
public:
	void initialize(void);
public:
	const Bundle* find(const std::string& name) const;
	const std::string& getBaseDir(void) const;
	const std::list<const Bundle*> getList(void) const;
	void show(void) const;
private:
	const std::string m_bundles_dir;
	typedef std::map<std::string, Bundle> name_bundle_map_t;
	name_bundle_map_t m_bundles;
private:
	BundleManagerIMPL();
};


}  // namespace RUNES

#endif /* bundlemgr_impl.h */
