#include "csv.h"
#include <string.h>

namespace VIVER {


// コンストラクタ
CSV::CSV(const char* data)
{
	if( data == NULL ) {
		m_data = NULL;
		m_pos_begin = NULL;
		m_pos_end = NULL;
		return;
	}

	m_data = new char[ ::strlen(data) + 1 ];
	::strcpy(m_data, data);

	m_pos_begin = &m_data[0];
	if( *m_pos_begin == '\0' ) {		// 空の文字列であった
		m_pos_begin = NULL;			// 終端に達したら必ずNULL
		m_pos_end = NULL;
	} else {
		m_pos_end = ::strchr(m_pos_begin, ',');	// ,が見つからなければ m_pos_end == NULL で良い
		if( m_pos_end != NULL )
			*m_pos_end = '\0';	// *m_pos_end は '\0' にする
	}
}


// デストラクタ
CSV::~CSV()
{
	delete[] m_data;
}


// public:
const char* CSV::get(void) const
{
	return m_pos_begin;		// end() != trueであればNULLは返らない
}

CSV& CSV::operator++ (void)
{
	if( m_pos_begin == NULL ) return *this;		// 開始位置も終端であった（当然終了位置も終端）
	if( m_pos_end == NULL ) {			// 終了位置が終端であった
		m_pos_begin = NULL;			// 開始位置を終端に進める
		return *this;
	}

	// 開始位置も終了位置も終端ではない
	// m_pos_begin を進める
	m_pos_begin = m_pos_end + 1;
	if( *m_pos_begin == '\0' ) {			// 開始位置が終端に達した（,の次が'\0'場合ここに来る）
		m_pos_end = NULL;
		return *this;
	}

	// m_pos_end を進める
	m_pos_end = ::strchr(m_pos_begin, ',');

	if( m_pos_end != NULL )
		*m_pos_end = '\0';		// *m_pos_end は '\0' にする

	return *this;
}

bool CSV::end(void) const
{
	if( m_pos_begin == NULL )
		return true;
	else
		return false;
}


}  // namespace VIVER
