#include "element.h"

#include <iostream>


namespace RUNES {


Element::Element(const std::string& name) :
	m_name(name)
{}

Element::~Element()
{}

      Element::list_type& Element::getChildren(void)
{
	return m_children;
}

const Element::list_type& Element::getChildren(void) const
{
	return m_children;
}

Element::const_iterator Element::getFirstChildByName(const std::string& name) const
{
	for(const_iterator elm(m_children.begin()), end(m_children.end());
			elm != end;
			++elm ) {
		if( elm->getName() == name ) {
			return elm;
		}
	}
	return this->end();
}

Element::const_reverse_iterator Element::getLastChildByName(const std::string& name) const
{
	for(const_reverse_iterator elm(m_children.rbegin()), rend(m_children.rend());
			elm != rend;
			++elm ) {
		if( elm->getName() == name ) {
			return elm;
		}
	}
	return this->rend();
}

const std::string& Element::getName(void) const
{
	return m_name;
}

Element& Element::appendChild(const Element& newChild)
{
	m_children.push_back(newChild);
	return *m_children.rbegin();
}

void Element::appendAttribute(const std::string& name, const std::string& value)
{
	m_attributes.insert( std::make_pair(name, value) );
}

const Element::attributes_type& Element::getAttributes() const
{
	return m_attributes;
}

void Element::appendText(const std::string& text)
{
	m_texts.push_back(text);
}

const Element::texts_type& Element::getTexts(void) const
{
	return m_texts;
}

const bool Element::hasText(void) const
{
	return ! m_texts.empty();
}

const std::string Element::getConnectedText(void) const
{
	std::string ret;
	for(texts_type::const_iterator begin(m_texts.begin()), end(m_texts.end());
			begin != end;
			++begin ) {
		ret += *begin;
	}
	return ret;
}


void Element::clear(void)
{
	m_children.clear();
	m_attributes.clear();
	m_texts.clear();
}


void Element::show(const std::string& head) const
{
	std::cout << head << "<" << getName();
	for(attributes_type::const_iterator att(m_attributes.begin()), end(m_attributes.end());
			att != end;
			++att ) {
		std::cout << " " << att->first << "=\"" << att->second << "\"";
	}
	std::cout << ">" << "\n";

	if( hasText() ) {
		std::cout << head << "  " << getConnectedText() << "\n";
	}
	for(const_iterator elm(this->begin()), end(this->end());
			elm != end;
			++elm ) {
		elm->show(head + "  ");
	}

	std::cout << head << "</" << getName() << ">" << std::endl;
}



}  // namespace RUNES
