#include "filesystem.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
//#include <cstdio>
// #include <errno.h>

namespace RUNES {


// コンストラクタ
FileSystem::FileSystem() {}


// デストラクタ
FileSystem::~FileSystem() {}


// public:
bool FileSystem::isSuffix(const std::string& base, const std::string& suffix)
{
	if( base.size() < (suffix.size() + 1) ) return false;
	if( base.substr( base.size() - suffix.size() ) != suffix ) return false;
	return true;
}

std::string FileSystem::removeSuffix(const std::string& base, const std::string& suffix)
{
	if( ! isSuffix(base,suffix) ) {
		return base;
	} else {
		return base.substr(0, base.size() - suffix.size() );
	}
}

std::string FileSystem::dirname(const std::string& path)
{
	std::string::size_type rpos_slash( path.rfind('/') );
	if( rpos_slash == std::string::npos ) {
		return ".";
	} else if( rpos_slash == 0 ) {
		return "/";
	} else if( rpos_slash == path.size()-1 ) {
		return dirname( path.substr(0,rpos_slash) );
	} else {
		return path.substr(0,rpos_slash);
	}
}

std::string FileSystem::basename(const std::string& path)
{
	std::string::size_type rpos_slash( path.rfind('/') );
	if( rpos_slash == std::string::npos ) {
		return path;
	} else if( rpos_slash == 0 ) {
		return "/";
	} else if( rpos_slash == path.size()-1 ) {
		return basename( path.substr(0,rpos_slash) );
	} else {
		return path.substr(rpos_slash + 1);
	}
}

FileSystem::file_type FileSystem::checkFileExists(const std::string& path)
{
	struct stat file_stat;
	if( ::stat( path.c_str(), &file_stat) == 0 ) {
		if( S_ISREG(file_stat.st_mode) ) {
			// 通常ファイル
			return REGULAR_FILE;
		} else if( S_ISDIR(file_stat.st_mode) ) {
			// ディレクトリ
			return DIRECTORY;
		} else {
			return OTHER;
		}
	} else {
		return NOT_EXISTS;
	}
}


}  // namespace RUNES
