#ifndef __FILESYSTEM_H_INCLUDED
#define __FILESYSTEM_H_INCLUDED 1

#include <string>

namespace RUNES {


class FileSystem {
public:
	FileSystem();
	~FileSystem();
public:
	static bool isSuffix(const std::string& base, const std::string& suffix);
	static std::string removeSuffix(const std::string& base, const std::string& suffix);
	static std::string dirname(const std::string& path);
	static std::string basename(const std::string& path);

	typedef enum {
		NOT_EXISTS = 0,
		REGULAR_FILE,
		DIRECTORY,
		OTHER,
	} file_type;
	static file_type checkFileExists(const std::string& path);	// throw()
};


}  // namespace RUNES

#endif /* filesystem.h */
