#include "bundlemgr.h"
#include "rolemgr.h"
#include "targetmgr.h"
#include "csv.h"
#include <iostream>
#include <cstdlib>

using namespace RUNES;


namespace {

int argParser(	int argc,
		char* argv[],
		std::string* services_dir,
		std::string* roles_dir,
		std::string* interface_dir,
		std::list<std::string>* use_roles
		);

}  // noname namespace


// $0  <path to services>  <path to roles>  <path to interface>  <role> [role] [role] ...
int main(int argc, char* argv[])
{
	// 要絶対パス
	std::string services_dir;
	std::string roles_dir;
	std::string interface_dir;
	std::list<std::string> use_roles;
	if( argParser(argc, argv, &services_dir, &roles_dir, &interface_dir, &use_roles) < 0 ) {
		std::cout << "Usage:  applyer  <path to services>  <path to roles>  <path to interface>  <role> [role] [role] ..." << std::endl;
		::exit(1);
	}

	BundleManager bmgr(services_dir);
	bmgr.initialize();
	bmgr.show();

	RoleManager rmgr(roles_dir);
	rmgr.initialize();
	rmgr.show();

	Applyer::TargetManager tmgr(bmgr, rmgr, use_roles);
	tmgr.initialize();
	tmgr.link();
	tmgr.show();

	tmgr.resolve();

	// 環境変数を設定
	::setenv("RUNES_SERVICES_DIR",  services_dir.c_str() , 1);
	::setenv("RUNES_ROLES_DIR",     roles_dir.c_str(),     1);
	::setenv("RUNES_INTERFACE_DIR", interface_dir.c_str(), 1);
	::setenv("PATH", "/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/sbin:/usr/local/bin:/usr/X11R6/bin:/usr/X11R7/bin", 1);
	tmgr.apply();

	return 0;
}


namespace {

int argParser(	int argc,
		char* argv[],
		std::string* services_dir,
		std::string* roles_dir,
		std::string* interface_dir,
		std::list<std::string>* use_roles
		)
{
	if( argc <= 4 ) {
		return -1;
	}

	*services_dir  = argv[1];
	*roles_dir     = argv[2];
	*interface_dir = argv[3];

	for(int i=4; i < argc; ++i) {
		use_roles->push_back(argv[i]);
	}

	return 0;
}

}  // noname namespace

