#include "bundlemgr.h"
#include "rolemgr.h"
#include "runemgr.h"
#include "installer.h"
#include <getopt.h>
#include <iostream>

#include "runemgr.h"
#include "rune.h"
#include "meta.h"
#include "metadb.h"
#include <map>
#include <fstream>

using namespace RUNES;


namespace {
int argParser(	int argc,
		char* argv[],
		std::string* services_dir,
		std::string* roles_dir,
		std::string* metadb_path,
		std::string* metadb_url,
		std::string* command,
		std::vector<std::string>* command_args
		);
void usage(void);
}  // noname namespace


using namespace Manager;
const Rune* useFirst(std::list<const Rune*>* list)
{
	std::cout << "Candidates: " << std::endl;
	//for(std::list<const Rune*>::const_iterator
	return *list->begin();
}


// $0  <path to services>  <path to roles>  <role,role,role,...>
int main(int argc, char* argv[])
{
	std::string services_dir;
	std::string roles_dir;
	std::string metadb_path;
	std::string metadb_url;
	std::string command;
	std::vector<std::string> command_args;
	if( argParser(argc, argv, &services_dir, &roles_dir, &metadb_path, &metadb_url, &command, &command_args) < 0 ) {
		std::cout << "Usage:  applyer  <path to services>  <path to roles>  <command>  <arg,arg,arg,...>" << std::endl;
		::exit(1);
	}

	MetaDB metadb("etc-RUNES/runes.db.xml", "http://viver.sourceforge.jp/");
	metadb.initialize();

	BundleManager bmgr(services_dir);	// 絶対パスでないといけない
	bmgr.initialize();
	bmgr.show();

	RoleManager rmgr(roles_dir);		// 相対パスでも良い
	rmgr.initialize();
	rmgr.show();

	RuneManager nmgr(metadb);
	nmgr.initialize();

	Installer installer(nmgr, bmgr);


#if 0
	MetaDB metadb("etc-RUNES/runes.db.xml", "http://viver.sourceforge.jp/");
	metadb.initialize();

	BundleManager bmgr("./etc-RUNES/runes");
	bmgr.initialize();
	bmgr.show();

	RuneManager nmgr(metadb);
	nmgr.initialize();
	const Rune* found( nmgr.find("ClusteredDHCPd") );
	if( found != NULL ) {
		std::cout << found->getSource().getName() << std::endl;
		try {
			std::list<const Rune*> lack( nmgr.getInstallDependency(found, bmgr, &useFirst) );
		} catch (const LackOfFile& lf) {
			std::string type;
			switch(lf.get()->getType()) {
			case BundleDepend::DEP_FILE:
				type = "file";
				break;
			case BundleDepend::DEP_LIB:
				type = "lib";
				break;
			case BundleDepend::DEP_BIN:
				type = "bin";
				break;
			case BundleDepend::DEP_AND:
			case BundleDepend::DEP_OR:
			case BundleDepend::DEP_BUNDLE:
				type = "BROKEN ERROR";
				break;
			}
			std::cout << "Lack of File (" << type << "): " << lf.get()->getName() << std::endl;
		}
	} else {
		std::cout << "Not such rune in RUNES DB." << std::endl;
	}
#endif

#if 0
	std::string services_dir;
	std::string roles_dir;
	std::string metadb_path;
	std::string metadb_url;
	std::string command;
	std::vector<std::string> command_args;
	if( argParser(argc, argv, &services_dir, &roles_dir, &metadb_path, &metadb_url, &command, &command_args) < 0 ) {
		std::cout << "Usage:  applyer  <path to services>  <path to roles>  <command>  <arg,arg,arg,...>" << std::endl;
		::exit(1);
	}

	BundleManager bmgr(services_dir);	// 絶対パスでないといけない
	bmgr.initialize();
	bmgr.show();

	RoleManager rmgr(roles_dir);		// 相対パスでも良い
	rmgr.initialize();
	rmgr.show();

	if( command == "install" ) {
		using namespace Manager;
		MetaDB metadb(metadb_path);
		metadb.initialize();
		RuneManager nmgr(metadb);
		Installer installer(nmgr, bmgr);
		return installer.command(command_args);
	}
#endif

	return 0;
}


namespace {

int argParser(	int argc,
		char* argv[],
		std::string* services_dir,
		std::string* roles_dir,
		std::string* metadb_path,
		std::string* metadb_url,
		std::string* command,
		std::vector<std::string>* command_args
		)
{
	*services_dir = "/etc/RUNES/runes";
	*roles_dir = "/etc/RUNES/roles";
	*metadb_path = "/etc/RUNES/runes.db.xml";
	*metadb_url = "http://viver.sourceforge.jp/runes/runes.db.xml";
	*command = "";

	struct option long_options[] = {
		// "long name", has_arg, *flag, val
		{"runes-dir", 1, 0, 'n'},
		{"roles-dir", 1, 0, 'r'},
		{"db", 1, 0, 'x'},
		{"help", 0, 0, 'h'},
		{0,0,0,0}
	};
	while(1) {
		int option_index = 0;
		int c = getopt_long(argc, argv, "n:r:x:h", long_options, &option_index);
		if(c == -1) break;

		switch(c) {
		case 's':
			*services_dir = optarg;
			break;
		case 'r':
			*roles_dir = optarg;
			break;
		case 'x':
			*metadb_path = optarg;
			break;
		case 'h':
			usage();
			exit(0);
			break;
		}
	}

	if(optind >= argc) {
		usage();
		exit(0);
		return -1;
	}
	*command = argv[optind];
	optind++;
	while(optind < argc) {
		command_args->push_back( argv[optind] );
		optind++;
	}

	std::cout << "runes dir:    " << *services_dir << std::endl;
	std::cout << "roles dir:    " << *roles_dir << std::endl;
	std::cout << "metadb path:  " << *metadb_path << std::endl;
	std::cout << "command:      " << *command << std::endl;
	for(std::vector<std::string>::const_iterator it( command_args->begin() );
			it != command_args->end();
			++it ) {
		std::cout << "arg: " << *it << std::endl;
	}

	exit(0);
	return 0;
}

void usage(void)
{
	std::cout << "Usage: runes [options] command args..."		<< std::endl;
	std::cout							<< std::endl;
	std::cout << "Options:"						<< std::endl;
	std::cout << "  -h   --help         Display this help and exit"	<< std::endl;
	std::cout << "  -n <directory>, --runes-dir=<directory>"	<< std::endl;
	std::cout << "                      Set services directory (default is /etc/RUNES/runes)"	<< std::endl;
	std::cout << "  -x </path/to/runes.db.xml>, --db=</path/to/runes.db.xml>"	<< std::endl;
	std::cout << "  -r <directory>, --roles-dir=<directory>"	<< std::endl;
	std::cout << "                      Set services directory (default is /etc/RUNES/roles)"	<< std::endl;
}

}  // noname namespace

