#ifndef __META_H_INCLUDED
#define __META_H_INCLUDED 1

#include "bundle_info.h"
#include <string>

namespace RUNES {

namespace Manager {


class Meta : public BundleInfoHolder {
friend class MetaDBParser;
public:
	Meta();
	~Meta();
public:
	void show(void) const;
public:
	const std::string& getLocation(void) const;
	uint64_t getSize(void) const;
	typedef enum {
		OK,
		FAIL,
		NOTSPECIFIED,
	} checked_t;
	checked_t checkSum(void) const;

	void clear(void);
private:
	std::string m_location;
	std::string m_checksum;
	std::string m_checksum_type;
	uint64_t m_size;
};


}  // namespace Manager

}  // namespace RUNES

#endif /* meta.h */
