#include "metadb_parser.h"
#include "metadb_parser.h"
#include "exception.h"
#include <sstream>
#include <boost/lexical_cast.hpp>

#include <iostream>

namespace RUNES {

namespace Manager {


// メタデータ
MetaDBParser::MetaDBParser(std::istream& source_stream, std::map<std::string, Meta>* result) :
	SAX(source_stream),
	m_current_info("BundleMeta"),
	m_docroot("MetaDB"),
	m_depth(0),
	m_current(BUNDLE),
	m_result(result)
{}


// デストラクタ
MetaDBParser::~MetaDBParser()
{}

// private:
Element* MetaDBParser::getTopElement(void)
{
	if( m_path.empty() ) {
		return &m_docroot;
	}
	return *(m_path.rbegin());
}

// private:
void MetaDBParser::initializer(void)
{
}

void MetaDBParser::finalizer(void)
{
}

void MetaDBParser::startElementHandler(const std::string& name, const attributes_t& attributes)
{
	if( m_depth == 1 && name == "rune" ) {
		m_current_meta.m_location = "";
		m_current_meta.m_checksum = "";
		m_current_meta.m_checksum_type = "";

	} else if( m_depth == 2 ) {
		if( name == "locale" ) {
			m_current = LOCALE;
		} else if( name == "checksum" ) {
			m_current = CHECKSUM;
			std::list<std::string> type_list( getAttrValue(attributes, "type") );
			if( ! type_list.empty() ) {
				m_current_meta.m_checksum_type = *type_list.begin();
			}
		} else if( name == "size" ) {
			m_current = SIZE;

		} else if( name == "bundle" ) {
			m_current = BUNDLE;
			m_current_info.clear();
			m_path.push_back(&m_current_info);
			m_path.push_back( &( m_current_info.appendChild(Element("bundle")) ) );
		}

	} else if( m_depth > 2 && m_current == BUNDLE ) {
		Element new_element(name);
		for(attributes_t::const_iterator attr(attributes.begin()), attr_end(attributes.end());
				attr != attr_end;
				++attr ) {
			new_element.appendAttribute(attr->first, attr->second);
		}
		m_path.push_back( &(getTopElement()->appendChild(new_element)) );
	}

	m_depth++;
}

void MetaDBParser::endElementHandler(const std::string& name)
{
	m_depth--;

	if( m_depth == 1 && name == "rune" ) {
		m_result->insert( std::make_pair(m_current_meta.getName(), m_current_meta) );
	} else if( m_depth == 2 && name == "bundle" ) {
		m_current_meta.parseInfo(m_current_info);
		m_path.pop_back();
		m_path.pop_back();
		std::cout << m_current_meta.getName() << std::endl;
	} else if( m_depth > 2 && m_current == BUNDLE ) {
		m_path.pop_back();
	}
}

void MetaDBParser::textHandler(const std::string& text)
{
	switch( m_current ) {
	case LOCALE:
		m_current_meta.m_location = text;
		break;
	case CHECKSUM:
		m_current_meta.m_checksum = text;
		break;
	case SIZE:
		try {
			m_current_meta.m_size = boost::lexical_cast<uint64_t>(text);
		} catch(std::runtime_error& ex) {}
		break;
	case BUNDLE:
		getTopElement()->appendText(text);
		break;
	}
}

void MetaDBParser::errorHandler(const std::string& message, unsigned long long line, unsigned long long column)
{
	std::cout << "XML Parse Error in " << line << ":" << column << " :  " << message << std::endl;
}


// private:
std::list<std::string> MetaDBParser::getAttrValue(const attributes_t& atts, const std::string& key) const
{
	std::list<std::string> vals;
	for( SAX::attributes_t::const_iterator att( atts.begin() );
			att != atts.end();
			++att ) {
		if( att->first == key ) {
			vals.push_back( att->second );
		}
	}
	return vals;
}


}  // namespace Manager

}  // namespace RUNES
