#ifndef __METADB_PARSER_H_INCLUDED
#define __METADB_PARSER_H_INCLUDED 1

#include "sax.h"
#include "element.h"
#include "meta.h"
#include <deque>
#include <map>
#include <string>
#include <list>

namespace RUNES {


namespace Manager {


class Meta;

class MetaDBParser : public SAX {
public:
	MetaDBParser(std::istream& source_stream, std::map<std::string, Meta>* result);
	~MetaDBParser();
private:
	void initializer(void);
	void finalizer(void);
	void startElementHandler(const std::string& name, const attributes_t& attributes);
	void endElementHandler(const std::string& name);
	void textHandler(const std::string& text);
	void errorHandler(const std::string& message, unsigned long long line, unsigned long long column);
private:
	Element* getTopElement(void);
private:
	// parsing context
	std::deque<Element*> m_path;
	Meta m_current_meta;
	Element m_current_info;
	attributes_t m_current_atts;
	Element m_docroot;
	unsigned int m_depth;

	enum {
		LOCALE,
		CHECKSUM,
		SIZE,
		BUNDLE,
	} m_current;

	// parsed result
	std::map<std::string, Meta>* m_result;
private:
	std::list<std::string> getAttrValue(const attributes_t& atts, const std::string& key) const;
};


}  // namespace Manager

}  // namespace RUNES

#endif /* metadb_parser.h */
