#ifndef __RUNE_H_INCLUDED
#define __RUNE_H_INCLUDED 1

#include "meta.h"
#include "bundle_info.h"
#include "version.h"
#include "exception.h"
#include <istream>
#include <list>
#include <string>
#include <boost/function.hpp>

namespace RUNES {

class BundleManager;


namespace Manager {

class RuneManager;


class Rune {
public:
	Rune(const Meta& source);
	~Rune();
public:
	bool isResolved(const BundleManager& bmgr) const;
	void getRecursiveBundleDepend(
			const BundleManager& bmgr,
			const RuneManager& nmgr,
			std::list<const Rune*>* list,
			boost::function<const Rune* (std::list<const Rune*>*)> askmethod
			) const;
		// throw( LackOfFile, NoBundleFound );

	void show(void) const;
private:
	const Meta& m_source;
public:
	const Meta& getSource(void) const { return m_source; }
private:
	bool isResolvedBASE   (const BundleManager& bmgr, const BundleDepend* obj) const;
	bool isResolvedAND    (const BundleManager& bmgr, const BDLogicAND*   obj) const;
	bool isResolvedOR     (const BundleManager& bmgr, const BDLogicOR*    obj) const;
	bool isResolvedBundle (const BundleManager& bmgr, const BDTBundle* obj) const;
	bool isResolvedFile   (const BDTHostFile* obj) const;
	bool isResolvedLib    (const BDTHostLib*  obj) const;
	bool isResolvedBin    (const BDTHostBin*  obj) const;

	bool isResolvedHostRequires(const BDTHost* obj) const;
	void getRecursiveBundleDependAND (
			const BundleManager& bmgr,
			const RuneManager& nmgr,
			std::list<const Rune*>* list,
			boost::function<const Rune* (std::list<const Rune*>*)> askmethod,
			const BDLogicAND* obj
			) const;
	void getRecursiveBundleDependOR  (
			const BundleManager& bmgr,
			const RuneManager& nmgr,
			std::list<const Rune*>* list,
			boost::function<const Rune* (std::list<const Rune*>*)> askmethod,
			const BDLogicOR* obj
			) const;
private:
	Rune();
};


// Exception
class DependencyUnsatisfied : public std::runtime_error {
public:
	DependencyUnsatisfied(const char* message) :
		runtime_error(message)
	{}
	virtual ~DependencyUnsatisfied() throw() {}
};

class LackOfFile : public DependencyUnsatisfied {
public:
	LackOfFile(const BDTHost* obj) :
		DependencyUnsatisfied("Lack of File"),
		m_obj(obj)
	{}
	~LackOfFile() throw() {}
public:
	const BDTHost* get(void) const { return m_obj; }
private:
	const BDTHost* m_obj;
private:
	LackOfFile();
};

class NoRuneFound : public DependencyUnsatisfied {
public:
	NoRuneFound(const BDTBundle* obj) :
		DependencyUnsatisfied("Lack of Rune"),
		m_obj(obj)
	{}
	virtual ~NoRuneFound() throw() {}
public:
	const BDTBundle* get(void) const { return m_obj; }
private:
	const BDTBundle* m_obj;
private:
	NoRuneFound();
};

class NoneOfEntriesSatisfied : public DependencyUnsatisfied {
public:
	NoneOfEntriesSatisfied(const BDLogicOR* obj) :
		DependencyUnsatisfied("None of entries in OR logic are satisfied"),
		m_obj(obj)
	{}
	virtual ~NoneOfEntriesSatisfied() throw() {}
private:
	const BDLogicOR* get(void) const { return m_obj; }
private:
	const BDLogicOR* m_obj;
private:
	NoneOfEntriesSatisfied();
};


}  // namespace Manager

}  // namespace RUNES

#endif /* rune.h */
