#include "runemgr.h"
#include "rune.h"
#include "filesystem.h"

namespace RUNES {

namespace Manager {


// コンストラクタ
RuneManager::RuneManager(const MetaDB& metadb) :
	m_metadb(metadb)
{}


// デストラクタ
RuneManager::~RuneManager()
{}


// public:
void RuneManager::initialize(void)
{
	const std::list<const Meta*> list( m_metadb.getList() );
	for(std::list<const Meta*>::const_iterator me(list.begin()), me_end(list.end());
			me != me_end;
			++me ) {
		m_runes.insert( std::make_pair((*me)->getName(), Rune(**me)) );
	}
}

const std::list<const Rune*> RuneManager::getInstallDependency(
		const Rune* target,
		const BundleManager& bmgr,
		boost::function<const Rune* (std::list<const Rune*>*)> askmethod
		) const
{
	std::list<const Rune*> list;
	target->getRecursiveBundleDepend(
			bmgr,
			*this,
			&list,
			askmethod
			);
	return list;
}

const Rune* RuneManager::find(const std::string name) const
{
	name_rune_map_t::const_iterator found( m_runes.find(name) );
	if( found == m_runes.end() ) {
		return NULL;
	} else {
		return &(found->second);
	}
}

const std::list<const Rune*> RuneManager::getList(void) const
{
	std::list<const Rune*> list;
	for( name_rune_map_t::const_iterator ru( m_runes.begin() );
			ru != m_runes.end();
			++ru ) {
		list.push_back( &(ru->second) );
	}
	return list;
}

const std::string RuneManager::getBaseURL(void) const
{
	return FileSystem::dirname(m_metadb.getDBURL());
}


}  // namespace Manager

}  // namespace RUNES

