#ifndef __SAX_H_INCLUDED
#define __SAX_H_INCLUDED 1

#include <istream>
#include <string>
#include <list>
#include <utility>
#include <boost/function.hpp>

namespace RUNES {


class SAXMapper;

class SAX {
friend class SAXMapper;
public:
	explicit SAX(std::istream& source_stream);
	virtual ~SAX();
public:
	void parse(void);
protected:
	typedef std::list< std::pair<std::string,std::string> > attributes_t;
private:
	virtual void initializer(void) {}
	virtual void finalizer(void) {}
	virtual void startElementHandler(const std::string& name, const attributes_t& attributes) = 0;
	virtual void endElementHandler(const std::string& name) = 0;
	virtual void textHandler(const std::string& text) = 0;
	virtual void errorHandler(const std::string& message, unsigned long long line, unsigned long long column) = 0;
protected:
	std::istream& m_stream;
private:
	SAX();
};


}  // namespace RUNES

#endif /* sax.h */
