#ifndef __TARGET_H_INCLUDED
#define __TARGET_H_INCLUDED 1

#include "bundle.h"
#include <string>
#include <list>
#include <pthread.h>
#include <boost/function.hpp>

namespace RUNES {

namespace Applyer {


class Target {
public:
	Target(const Bundle& source, const std::string& config_path);
	~Target();
public:
	// for resolving
	std::list<Target*> resolve(void);
	bool isResolved(void) const;

	// for linking
	const std::list<std::string> getSourcePreOrder (void)  const;
	const std::list<std::string> getSourcePostOrder(void) const;
	void pushPreRequre(Target* target);

	// for applying
	void start(void);
	void wait(void);
	void collect(void);

	// for debugging
	const std::string& getName(void) const;
	void show(void) const;
private:
	// linked data
	std::list<Target*> m_pre_requres;

	// for resolving
	bool m_resolving;
	bool m_resolved;
	bool m_circle_connect;
private:
	// for applying
	static void* startThread(void* self);
	void startIMPL(void);
private:
	const Bundle& m_source;
	const std::string  m_config_path;

	// for applying
	pthread_t m_thread;
	pthread_mutex_t m_mutex;
	pthread_cond_t m_cond;
	bool m_applied;
};


class CircularPreRequresError : public std::runtime_error {
public:
	CircularPreRequresError(const char* message, std::list<Target*>& circle_list) :
		runtime_error(message),
		m_circle_list(circle_list)
	{}
	CircularPreRequresError(const std::string& message, std::list<Target*>& circle_list) :
		runtime_error(message),
		m_circle_list(circle_list)
	{}
public:
	const std::list<Target*>& getList(void) const
	{ return m_circle_list; }
private:
	std::list<Target*> m_circle_list;
};


}  // namespace Applyer

}  // namespace RUNES

#endif /* target.h */
