#ifndef __TARGETMGR_H_INCLUDED
#define __TARGETMGR_H_INCLUDED 1

#include "bundlemgr.h"
#include "rolemgr.h"
#include "target.h"
#include <string>
#include <map>

namespace RUNES {

namespace Applyer {


class TargetManager {
public:
	TargetManager(const BundleManager& bmgr, const RoleManager& rmgr, const std::list<std::string> use_roles);
	~TargetManager();
public:
	void initialize(void);
public:
	// for linking
	void link(void);

	// for resolving
	void resolve(void);

	// for applying
	void apply(void);

	// for debugging
	void show(void) const;
private:
	Target* find(const std::string& name);
private:
	// for reslving
	bool isAllResolved(void) const;
	void driveAway(Target* target);
private:
	const BundleManager& m_bmgr;
	const RoleManager& m_rmgr;
	const std::list<std::string> m_use_roles;
private:
	typedef std::map<std::string, Target> name_target_map_t;
	name_target_map_t m_targets;
private:
	TargetManager();
};


}  // namespace Applyer

}  // namespace RUNES

#endif /* targetmgr.h */
