#include "rpcserver.h"
#include "node.h"
#include "ip46.h"
#include "vfield.h"
#include "datarange.h"
#include "log.h"

#include <cstring>
#include <iostream>
#include <boost/scoped_ptr.hpp>

using namespace VFIELD;

int main(void)
{
	ThreadPool pool(5);
	boost::scoped_ptr<RPCServer> rpc;
	try {
		rpc.reset( new RPCServer("12345", pool) );
	} catch( const RPCListenException& ex ) {
		std::cerr << ex.what() << std::endl;
	}

	sleep(1);

	NodeIdentity self("127.0.0.1", "12345");
	int sock = socketUDP4();
	char buf[RPC_MAX_BODY_SIZE + RPC_COMMON_HEADER_SIZE + 10];
	::memset(buf, 0, sizeof(buf));

	{  // RPC_NOTIFY_UP
		buf[0] = RPC_NOTIFY_UP_MAGIC;


		NodeIdentity up("192.168.0.2", "19061");
		::memcpy(&buf[RPC_COMMON_HEADER_SIZE + 0], up.getNetRaw(), NodeIdentity::raw_size);

		DataRange range(10, 120);
		::memcpy(&buf[RPC_COMMON_HEADER_SIZE + 19], range.getNetRaw().get(), DataRange::raw_size);

		int ret = sendto46(sock, buf, RPC_COMMON_HEADER_SIZE + RPC_NOTIFY_UP_SIZE, 0, self);
		LogDebug( Log::format("sent RPC Notify Up: %1%") % ret );
	}

	{  // RPC_NOTIFY_DOWN
		buf[0] = RPC_NOTIFY_DOWN_MAGIC;

		NodeIdentity down("192.168.0.2", "19061");
		::memcpy(&buf[RPC_COMMON_HEADER_SIZE + 0], down.getNetRaw(), NodeIdentity::raw_size);

		int ret = sendto46(sock, buf, RPC_COMMON_HEADER_SIZE + RPC_NOTIFY_DOWN_SIZE, 0, self);
		LogDebug( Log::format("sent RPC Notify Down: %1%") % ret );
	}

	{  // RPC_FIND
		buf[0] = RPC_FIND_MAGIC;

		DataRange query(100, 2000);
		::memcpy(&buf[RPC_COMMON_HEADER_SIZE + 0], query.getNetRaw().get(), DataRange::raw_size);

		NodeIdentity up("192.168.0.2", "19061");
		::memcpy(&buf[RPC_COMMON_HEADER_SIZE + 16], up.getNetRaw(), NodeIdentity::raw_size);

		DataRange range(10, 120);
		::memcpy(&buf[RPC_COMMON_HEADER_SIZE + 37], range.getNetRaw().get(), DataRange::raw_size);

		int ret = sendto46(sock, buf, RPC_COMMON_HEADER_SIZE + RPC_FIND_SIZE, 0, self);
		LogDebug( Log::format("sent RPC Notify Find: %1%") % ret );
	}

	::close(sock);

	sleep(2);
}
