#include "stream.h"
#include "node.h"
#include "ip46.h"
#include "threadpool.h"
#include "cache/storage.h"
#include <iostream>

using namespace VFIELD;

int main(void)
{
	ThreadPool pool(3);
	RootStorage rstorage("test.img");
	StreamManager smng("1900", rstorage, pool);

	NodeIdentity testserver("127.0.0.1", "12345");
	char buf[200];

	for(int i=0; i < 100; i++ ) {
		std::cout << "is connected: " << smng.isConnected(testserver) << std::endl;
		DataRange range(i*50, i*50+50);
		smng.streamGetData(testserver, range, buf);
		buf[range.length()] = '\0';
		std::cout << buf << std::endl;
	}

	return 0;
}
