#ifndef __CONTROLER_H_INCLUDED
#define __CONTROLER_H_INCLUDED 1

#include "virtualdevice.h"
#include "parameters.h"
#include "logd.h"
#include "devicemanager.h"
#include "devicenode.h"
#include "mountable.h"
#include "network.h"
#include "sharedblock.h"

#define VIVER_CL_ARG		(const std::string& command)
#define VIVER_CL_RET		void
#define VIVER_CL_DECL(func)	VIVER_CL_RET func VIVER_CL_ARG

namespace VIVER {


// 例外
VIVER_MakeRuntimeError( UnreadableParameterError );
VIVER_MakeRuntimeError( InsufficientMemoryError );


class Controler {
public:
	Controler();
	~Controler();
public:
	VIVER_CL_DECL( initial			);  // throw(bad_alloc, MountError, ExecuteFailedError, NoSuchFileError)
	VIVER_CL_DECL( mountArk			);  // throw(bad_alloc, MountError)
	VIVER_CL_DECL( startLogd		);  // throw(bad_alloc, ExecuteFailedError)

	VIVER_CL_DECL( newDevmanager		);  // throw(bad_alloc, MountError, ExecuteFailedError)
	VIVER_CL_DECL( mountModules		);  // throw(MountError, ExecuteFailedError)
	VIVER_CL_DECL( detectHardware		);  // throw(runtime_error)
	VIVER_CL_DECL( loadSystemModules	);  // throw()

	bool isToRAM(void);
	VIVER_CL_DECL( mountToRAMFS		);  // throw(bad_alloc, MountError)
	VIVER_CL_DECL( toRAM			);  // throw(NoSuchFileError, bad_alloc, ExecuteFailedError)
	VIVER_CL_DECL( losetupCompressedOnRAM	);  // throw(ExecuteFailedError)

	bool isBootFormDisk(void);
	VIVER_CL_DECL( mountBootDisk		);  // throw(DeviceNotFoundError, MountError)
	VIVER_CL_DECL( wakeNetwork		);  // throw(bad_alloc, ExecuteFailedError, NoSuchFileError,
						    //       NoNetworkInterfaceAvailableError,
						    //       NetworkInterfaceConfigrationFailedError )
	VIVER_CL_DECL( losetupCompressedOnDisk	);  // throw(ExecuteFailedError)
	VIVER_CL_DECL( connectSBD		);  // throw(FileSystemError, ExecuteFailedError, SBDConnectFailedError)
	VIVER_CL_DECL( mountCompressed		);  // throw(MountError)

	bool isRAMScreen(void);
	VIVER_CL_DECL( mountDirectScreen	);  // throw(DeviceNotFoundError, MountError)
	VIVER_CL_DECL( losetupLoopScreen	);  // throw(ExecuteFailedError)
	VIVER_CL_DECL( configureRAMScreen	);  // throw()
	VIVER_CL_DECL( mountScreen		);  // throw(MountError)

	VIVER_CL_DECL( losetupFixed		);  // throw(ExecuteFailedError)

	VIVER_CL_DECL( makeSparse		);  // throw(ExecuteFailedError, UnreadableParameterError)
	VIVER_CL_DECL( connectSparse		);  // throw(ExecuteFailedError, SparseFailedError)
	VIVER_CL_DECL( formShadow		);  // throw(NoSuchFileError, ExecuteFailedError)

	VIVER_CL_DECL( mountFormedImage		);  // throw(MountError)
	VIVER_CL_DECL( expandFormedImage	);  // throw(ExecuteFailedError)

	VIVER_CL_DECL( umountModuleDisk		);  // throw(MountError);

	VIVER_CL_DECL( switchRoot		);  // throw(MountError);

	VIVER_CL_DECL( editSysRoot		);  // throw()
	VIVER_CL_DECL( outputParameters		);  // throw()

	VIVER_CL_DECL( stopLogd			);  // throw()
	VIVER_CL_DECL( rc			);  // throw(ExecuteFailedError)
	VIVER_CL_DECL( post			);  // throw(MountError)
private:
	unsigned long decideDefaultSparseSize() const;
private:
	// initial
	VirtualDevice* vd_proc;
	VirtualDevice* vd_sys;
	std::string kernel_release;
	Parameters* parameters;

	// mountArk
	VirtualDevice* vd_ark;

	// startLogd
	LogDaemon* logd;

	// newDevmanager
	DeviceManager* devmanager;

	// mountModules
	DeviceNode* dn_modules;

	// detectHardware

	// loadSystemModules

	// toRAMfromDisk
	// toRAMfromSBD
	VirtualDevice* vd_toram;
	std::string compressed_on_toram;

	// mountBootDisk
	// wakeNetwork
	// losetupCompressedOnDisk, connectSBD
	std::string compressed_on_bootdisk;
	Mountable* mb_bootdisk;

	Network* network;

	bool boot_from_disk;
	DeviceNode* dn_compressed;
	SharedBlockDevice* sbd;

	// mountDirectScreen
	std::string screen_keyfile;
	Mountable* mb_container;

	// loopsetupLoopScreen, configureRAMScreen
	bool ram_shadow;
	Mountable* mb_screen;
	std::string shadow_on_screen;		// 指定できない

	// mountScreen

	// loopsetupFiexed
	std::string fixed_on_compressed;
	DeviceNode* dn_fixed;

	// makeSparse
	std::string sparse_on_screen;		// 指定できない

	// connectSparse
	DeviceNode* dn_sparse;
	DeviceNode* dn_sparsed_fixed;

	// formShadow
	DeviceNode* dn_formed;

	// ...
public:
	const char* getParameterString(const char* key, const char* default_value) const {
		if( parameters == NULL ) return default_value;
		else return parameters->getValueString(key, default_value);
	}
};


}  // namespace VIVER

#endif /* controler.h */
