#ifndef __DEVICENODE_CANDIDATE_H_INCLUDED
#define __DEVICENODE_CANDIDATE_H_INCLUDED 1

#include "filesystem.h"
#include "path.h"
#include <string>
#include <deque>
#include <pthread.h>

namespace VIVER {


class DeviceNodeCandidate {
public:
	typedef enum {
		FIXED_HDD,
		REMOBAVLE_HDD,
		DVD,
		CD
	} media_type_t;
	DeviceNodeCandidate(FileSystem::major_t major, FileSystem::minor_t minor,
			const Path& dev_path, const std::string& node_name,
			media_type_t media);
	~DeviceNodeCandidate();
public:
	typedef enum {
		ALL_TESTED,
		MOUNT_FAILED,
		MOUNT_SUCCESS,
		DIRECTORY_ERROR
	} test_stat_t;
	static const unsigned long MOUNT_TEST_FLAGS;
	static const std::string MOUNT_TEST_DATA_STRING;
public:
	FileSystem::major_t getMajor(void) { return m_major; }
	FileSystem::minor_t getMinor(void) { return m_minor; }
	const std::string& getNodeName(void) { return m_node_name; }
public:
	void startTestMount(void);
	static void* tc_testMount(void* target);
	test_stat_t waitTestMount(std::string* return_fstype,
			unsigned long* return_mount_flags, std::string* return_data_string);

	const Path& getTestPoint(void) const { return m_test_point; }
	Path getNodePath(void) const { return m_dev_path + m_node_name; }
private:
	const FileSystem::major_t m_major;
	const FileSystem::minor_t m_minor;
	const Path& m_dev_path;
	const std::string m_node_name;
	const media_type_t m_media;
	Path m_test_point;
	std::deque<std::string> m_untested_fstype;

	pthread_t m_test_thread;
	bool m_threading;
	test_stat_t m_return_value;
	std::string m_return_fstype;
	unsigned long m_return_mount_flags;
	std::string m_return_data_string;
private:
	DeviceNodeCandidate();			// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* devicenode_candidate.h */
