#include "display.h"
#include "display_impl.h"

namespace VIVER {


namespace host {
	Display display;
}


// コンストラクタ
Display::Display()
{
	m_impl = new DisplayIMPL();
}

// デストラクタ
Display::~Display()
{
	delete m_impl;
}


// public:
void Display::configure(const Parameters& parameters)
{
	m_impl->configure(parameters);
}

std::ostream& Display::debug(void)
{
	return m_impl->debug();
}

std::ostream& Display::verbose(void)
{
	return m_impl->verbose();
}

std::ostream& Display::notice(void)
{
	return m_impl->notice();
}

std::ostream& Display::warn(void)
{
	return m_impl->warn();
}

std::ostream& Display::error(void)
{
	return m_impl->error();
}


}  // namespace VIVER
