#include "display_impl.h"
#include "constant.h"
#include <fstream>

namespace VIVER {


// コンストラクタ
DisplayIMPL::DisplayIMPL() :
	m_console(),
	m_log(),
	m_dm_debug   (m_console, m_log),
	m_dm_verbose (m_console, m_log),
	m_dm_notice  (m_console, m_log),
	m_dm_warn    (m_console, m_log),
	m_dm_error   (m_console, m_log)
{
	m_dm_debug.startLog();

	m_dm_verbose.startLog();

	m_dm_notice.startConsole();
	m_dm_notice.startLog();

	m_dm_warn.startConsole();
	m_dm_warn.startLog();

	m_dm_error.startConsole();
	m_dm_error.startLog();
}


// デストラクタ
DisplayIMPL::~DisplayIMPL()
{
	// 文字色を元に戻す
	std::cout << Color::NORMAL << std::flush;
	showPrintk();
}


// public:
void DisplayIMPL::configure(const Parameters& parameters)
{
	if( parameters.getValueBool("debug",false) ) {
		host::display.notice() << "Setting DEBUG and VERBOSE level message and kernel message to show." << std::endl;
		m_dm_debug.startConsole();
		m_dm_verbose.startConsole();
		// showPrintk();  // デフォルトで表示される
	} else if( parameters.getValueBool("verbose",false) ) {
		host::display.notice() << "Setting VERBOSE level message to show." << std::endl;
		m_dm_verbose.startConsole();
		hidePrintk();
	} else if( parameters.getValueBool("silent", false) ) {
		host::display.notice() << "Setting NOTICE level message not to show." << std::endl;
		m_dm_notice.stopConsole();
		hidePrintk();
	} else {
		hidePrintk();
	}
}


// private:
void DisplayIMPL::hidePrintk(void)
{
	std::ofstream printk(Component::Kernel::PATH_PROC_PRINTK);
	if( printk.is_open() ) {
		printk << "0";
		printk.close();
	}
	// 開けなかったら無視
}

void DisplayIMPL::showPrintk(void)
{
	std::ofstream printk(Component::Kernel::PATH_PROC_PRINTK);
	if( printk.is_open() ) {
		printk << "1";		// XXX: これであっている？
		printk.close();
	}
	// 開けなかったら無視
}


}  // namespace VIVER
