#ifndef __FILESYSTEM_H_INCLUDED
#define __FILESYSTEM_H_INCLUDED 1

#include "path.h"
#include "exception.h"
#include <string>

namespace VIVER {


// 例外
VIVER_MakeRuntimeError( FileSystemError );


class FileSystem {
public:
	FileSystem();
	~FileSystem();
public:
	typedef unsigned short major_t;
	typedef unsigned short minor_t;
	typedef unsigned short perm_t;
public:
	static int remove(const std::string& path);	// throw()
	static int remove(const Path&        path)	// throw()
	{ return remove(path.str()); }

	static int makeDir(const std::string& path, perm_t perm);	// throw()

	static int makeDirForce(const std::string& path, perm_t perm);	// throw()
	static int makeDirForce(const Path&        path, perm_t perm)	// throw()
	{ return makeDirForce(path.str(), perm); }

	static int makeCharacterNode(major_t major, minor_t minor, const std::string& path, perm_t perm);	// throw()
	static int makeCharacterNodeForce(major_t major, minor_t minor, const std::string& path, perm_t perm);	// throw()
	static int makeCharacterNodeForce(major_t major, minor_t minor, const Path&        path, perm_t perm)	// throw()
	{ return makeCharacterNodeForce(major, minor, path.str(), perm); }

	static int makeBlockNode(major_t major, minor_t minor, const std::string& path, perm_t perm);		// throw()
	static int makeBlockNodeForce(major_t major, minor_t minor, const std::string& path, perm_t perm);	// throw()
	static int makeBlockNodeForce(major_t major, minor_t minor, const Path&        path, perm_t perm)	// throw()
	{ return makeBlockNodeForce(major, minor, path.str(), perm); }

	static void copyFile(const std::string& src, const std::string& dest);	// throw(FileSystemError)
	static void copyFile(const Path&        src, const Path&        dest)	// throw(FileSystemError)
	{ return copyFile(src.str(), dest.str()); }

	// byte単位のサイズを返す エラーなら0を返す
	static uint64_t getFileSize(const std::string& path);  // throw();
	static uint64_t getFileSize(const Path&        file)   // throw()
	{ return getFileSize( file.str() ); }

	static int move(const std::string& from, const std::string& to);	// throw()

	static int cd(const std::string& path);	// throw()
	static int cd(const Path&        path)	// throw()
	{ return cd(path.str()); }

	static std::string dirname(const std::string& path);	// throw()


	typedef enum {
		REGULAR_FILE,
		DIRECTORY,
		OTHER,
		NOT_EXISTS,
	} file_type;
	static file_type checkFileExists(const Path& path);	// throw()

	static int prepareDir(const std::string& path);		// throw()
};


}  // namespace VIVER

#endif /* filesystem.h */
