#ifndef __LINEARIZER_H_INCLUDED
#define __LINEARIZER_H_INCLUDED 1

#include "parameters.h"
#include "devicemanager.h"
#include "exception.h"
#include <string>
#include <vector>

namespace VIVER {


// 例外
VIVER_MakeRuntimeError( SparseFailedError );


class Linearizer {
public:
	explicit Linearizer(DeviceManager& _devmanager);	// throw()
	~Linearizer();		// throw()
public:
	void addDevice(const DeviceNode* dn);		// throw()
	DeviceNode* linearize(const std::string& fstype, unsigned long mount_flags, const std::string& data_string);
		// throw(ExecuteFailedError, SparseFailedError)
public:
	static const char* KERNEL_MODULE;
private:
	DeviceManager& devmanager;
	std::vector<const DeviceNode*> dn_list;
private:
	Linearizer();				// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* linearizer.h */
