#include "logd.h"
#include "constant.h"
#include "display.h"
#include "exception.h"

namespace VIVER {


// コンストラクタ
LogDaemon::LogDaemon(const char* file) :
	m_ps_syslogd(Component::Program::SYSLOGD)
{
	// m: fork() しない
	// O: 出力先ファイル
	m_ps_syslogd % "-n" % "-O" % file;
}


// デストラクタ
LogDaemon::~LogDaemon()
{}


// public:
void LogDaemon::start(void)
{
	m_ps_syslogd.exec(false,false);
}

void LogDaemon::stop(void)
{
	m_ps_syslogd.signalTerm();
	m_ps_syslogd.wait();
}


}  // namespace VIVER
