#ifndef __NETWORK_H_INCLUDED
#define __NETWORK_H_INCLUDED 1

#include "parameters.h"
#include "process.h"
#include "exception.h"
#include <boost/utility.hpp>

namespace VIVER {


// 例外
VIVER_MakeRuntimeError( NoNetworkInterfaceAvailableError );
VIVER_MakeRuntimeError( NetworkInterfaceConfigurationFailedError );


class NetworkInterface {
public:
	NetworkInterface(unsigned short index, const std::string& name);	// throw()
	~NetworkInterface();		// throw(bad_alloc)
public:
	const std::string& getName(void) const;		// throw()
	std::pair<int,int> startDHCP(void);		// throw(bad_alloc, ExecuteFailedError)
	std::pair<int,int> startAutoIP(void);		// throw(bad_alloc, ExecuteFailedError)
	std::pair<int,int> startStaticIP(const std::string& ipaddr, const std::string& netmask);
							// throw(bad_alloc, ExecuteFailedError)

	int waitDHCP(void);				// throw(ExecuteFailedError)
	int waitAutoIP(void);				// throw(ExecuteFailedError)
	int waitStaticIP(void);				// throw(ExecuteFailedError)

	inline bool isDHCPActive(void);			// throw()
	inline bool isAutoIPActive(void);		// throw()
	inline bool isStaticIPActive(void);		// throw()

	// XXX: 未実装
	std::string getIPAddr(void);			// throw()
private:
	typedef enum {
		DHCP,
		AUTOIP,
		STATICIP,
		NONE
	} method_t;
private:
	unsigned short m_index;
	std::string m_name;
	method_t m_running_method;
	Process *m_ps_dhcpc;
	Process *m_ps_autoip;
	Process *m_ps_staticip;
};


class Network : private boost::noncopyable {
public:
	Network(const Parameters& _parameters);
	~Network();
public:
	void wakeup(void);	// throw(bad_alloc, ExecuteFailedError, NoSuchFileError
				//       NoNetworkInterfaceAvailableError,
				//       NetworkInterfaceConfigurationFailedError )
public:
	static const std::string KERNEL_MODULE;
private:
	const Parameters& parameters;
	typedef std::map<std::string, NetworkInterface> netif_map_t;
	typedef std::list<NetworkInterface*> netif_class_t;
	netif_map_t m_netif_map;
	netif_class_t m_unconfigured_netif;
private:
	void lookupInterfaces(void);	// throw(NoSuchFileError)
	void analyzeStaticIPLine(const char* line, std::string* return_netdev, std::string* return_ipaddr, std::string* return_netmask) const;
};


}  // namespace VIVER

#endif /* network.h */
