#include "path.h"

namespace VIVER {


// コンストラクタ
Path::Path(const std::string& path)
{
	(*this) = path;
}

Path::Path()
{}


// デストラクタ
Path::~Path()
{}


// public:
Path& Path::operator+= (const std::string& path)
{
	std::string rest( path );
	std::string::size_type pos_sl;
	for(;;) {
		pos_sl = rest.find('/');
		if( pos_sl != std::string::npos ) {
			if( ! rest.substr(0,pos_sl).empty() )
				m_relative.push_back( rest.substr(0,pos_sl) );
			rest = rest.substr(pos_sl + 1);
		} else {
			if( ! rest.empty() )
				m_relative.push_back(rest);
			break;
		}
	}
	cache();

	return *this;
}

Path& Path::operator+= (const Path& path)
{
	m_relative.insert( m_relative.end(), path.m_relative.begin(), path.m_relative.end() );
	cache();
	return *this;
}

Path& Path::operator= (const std::string& path)
{
	m_relative.clear();

	std::string rest( path );
	std::string::size_type pos_sl;
	for(;;) {
		pos_sl = rest.find('/');
		if( pos_sl != std::string::npos ) {
			if( ! rest.substr(0,pos_sl).empty() )
				m_relative.push_back( rest.substr(0,pos_sl) );
			rest = rest.substr(pos_sl + 1);
		} else {
			if( ! rest.empty() )
				m_relative.push_back(rest);
			break;
		}
	}
	cache();

	return *this;
}

Path Path::operator+ (const std::string& path) const
{
	Path copy(*this);
	copy += path;
	return copy;
}

Path Path::operator+ (const Path& path) const
{
	Path copy(*this);
	copy += path;
	return copy;
}

Path Path::chroot(const std::string& root) const
{
	// XXX: もっと効率の良い実装を
	std::string path( str() );
	if( path.substr(0, root.size()) == root ) {
		return Path( path.substr( root.size() ) );
	} else {
		// アクセスできない位置にある
		// XXX: 処置は？ throwする？
		return Path( path );
	}
}

void Path::cache(void)
{
	m_cache = "";
	for(std::vector<std::string>::const_iterator rel( m_relative.begin() );
			rel != m_relative.end();
			++rel ) {
		m_cache = m_cache + "/" + *rel;
	}
	if( m_cache.empty() )
		m_cache = "/";
}

bool Path::isChildOf(const Path& parent) const
{
	if( parent.m_relative.size() > m_relative.size() ) return false;
	int i = 0;
	for(std::vector<std::string>::const_iterator ite( parent.m_relative.begin() );
			ite != parent.m_relative.end();
			++ite ) {
		if( *ite != m_relative[i] )
			return false;
		i++;
	}
	return true;
}


}  // namespace VIVER
