#ifndef __PCIIDS_H_INCLUDED
#define __PCIIDS_H_INCLUDED 1

#include "pciids_types.h"

namespace SimpleDetect {


class PCIIDs {
public:
	PCIIDs(const std::string& ids_path);
	~PCIIDs();
public:
	void load(void);
public:
	const std::string* getVendorName(PCIIDTypes::Vendor::id_type id) const;
	const std::string* getDeviceName(PCIIDTypes::Vendor::id_type vendor_id, PCIIDTypes::Device::id_type device_id) const;
	const std::string* getBaseClassName(PCIIDTypes::BaseClass::id_type id) const;
	const std::string* getSubClassName(PCIIDTypes::BaseClass::id_type base_id, PCIIDTypes::SubClass::id_type sub_id) const;
private:
	std::string m_ids_path;
	PCIIDTypes::VendorDeviceMap m_idmap;
	PCIIDTypes::ClassMap m_classmap;
private:
	PCIIDs();
};


}  // namespace SimpleDetect

#endif /* pciids.h */
