#ifndef __PROCESS_H_INCLUDED
#define __PROCESS_H_INCLUDED 1

#include "pipe.h"
#include "exception.h"
#include <utility>
#include <vector>
#include <boost/utility.hpp>

namespace VIVER {
 

// 例外
VIVER_MakeRuntimeError( ExecuteFailedError );


class Process : private boost::noncopyable {
public:
	explicit Process(const char* path);		// throw(bad_alloc)
	~Process();					// throw()
public:
	Process& operator% (const char* arg);		// throw(bad_alloc)
	std::pair<int, int>
		exec(bool grub_cout = false, bool grub_cerr = false);
							// パイプを処理せずにそのまま表示させる場合は、falseを渡す
							// exec().first = cout, exec().second = cerr
							// throw(bad_alloc, ExcuteFailedError)

	void chroot_exec(const std::string& chroot_path, const std::string& cout_path = "/dev/null", const std::string& cerr_path = "/dev/null");
							// コンストラクタに与える path は chroot_path を / としたパス！
							// fork() -> chroot() -> パイプ処理 -> exec
							// cout_path, cerr_path は chroot_path を / としたパス
							// throw(bad_alloc, ExcuteFailedError)
	//void exec_r(void);

	int wait(void);					// throw(ExecuteFailedError)
	//int wait_r(void);
	bool isActive(void);				// throw()

	int signalTerm(void);				// throw()
private:
	const char* m_path;
	std::vector<char*> m_args;
	int m_pid;

	bool m_waited;
	int m_exit_status;
private:
	Process();					// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* process.h */
