#ifndef __SDBASE_H_INCLUDED
#define __SDBASE_H_INCLUDED 1

#include <utility>
#include <string>
#include <functional>
#include <cstdlib>
#include <list>

namespace SimpleDetect {


template<typename Primary, typename Secondary>
class DualID {
public:
	typedef Primary   primary_type;
	typedef Secondary secondary_type;
public:
	DualID(primary_type primary, secondary_type secondary) :
		m_primary(primary),
		m_secondary(secondary)
	{}
	~DualID()
	{}
public:
	bool operator< (const DualID<primary_type, secondary_type>& rhl) const
	{ return (m_primary < rhl.m_primary) || (m_primary == rhl.m_primary && m_secondary < rhl.m_secondary); }
private:
	primary_type   m_primary;
	secondary_type m_secondary;
private:
	DualID();
};


class ModuleLoader : public std::unary_function<const std::string&, void> {
public:
	ModuleLoader() {};
	virtual ~ModuleLoader() {};
public:
	virtual void operator() (const std::string& module)
	{
		std::string command("modprobe ");
		command += module;
		::system(module.c_str());
	}
};

class ModuleCollector : public ModuleLoader {
public:
	void operator() (const std::string& module)
	{	m_list.push_back(module);	}
	const std::list<std::string>& getList(void) const
	{	return m_list;			}
private:
	std::list<std::string> m_list;
};


}  // namespace SimpleDetect

#endif /* sdbase.h */
