#include "sdpci.h"
#include "sdpci_impl.h"

namespace SimpleDetect {


// コンストラクタ
sdPCI::sdPCI(const std::string& ids_path, const std::string map_path) :
	m_impl( new sdPCIIMPL(ids_path, map_path) )
{}

// デストラクタ
sdPCI::~sdPCI()
{}


// public:
void sdPCI::initialize(void)
{
	m_impl->initialize();
}

void sdPCI::setBaseClassBasedLoadConfig  (const std::string& class_substr, load_config_t config)
{
	m_impl->setBaseClassBasedLoadConfig(class_substr, config);
}

void sdPCI::setSubClassBasedLoadConfig   (const std::string& class_substr, load_config_t config)
{
	m_impl->setSubClassBasedLoadConfig(class_substr, config);
}

void sdPCI::setKnownClassBasedLoadConfig (known_class_t known_class, load_config_t config)
{
	m_impl->setKnownClassBasedLoadConfig(known_class, config);
}

void sdPCI::detect(ModuleLoader& loader)
{
	m_impl->detect(loader);
}

void sdPCI::showDetectedDevices(std::ostream& stream) const
{
	m_impl->showDetectedDevices(stream);
}

void sdPCI::getDetectedDevices(std::vector<DetectedDevicePCI>& result) const
{
	m_impl->getDetectedDevices(result);
}


}  // namespace SimpleDetect
