#ifndef __SDPCI_IMPL_H_INCLUDED
#define __SDPCI_IMPL_H_INCLUDED 1

#include "sdpci.h"
#include "pciids.h"
#include "pcimap.h"
#include <list>
#include <map>
#include <functional>

namespace SimpleDetect {


struct PCIDevice {
	PCIIDTypes::Vendor::id_type vendor_id;
	PCIIDTypes::Device::id_type device_id;
	// PCIIDTypes::SubVendor::id_type subvendor_id;
	// PCIIDTypes::SubDevice::id_type subdevice_id;
	PCIIDTypes::BaseClass::id_type baseclass_id;
	PCIIDTypes::SubClass::id_type  subclass_id;
	std::list<std::string> modules;
	unsigned int irq;
	bool loaded;
};


class sdPCIIMPL {
public:
	sdPCIIMPL(const std::string& ids_path, const std::string map_path);
	~sdPCIIMPL();
public:
	void initialize(void);
public:
	typedef sdPCI::load_config_t load_config_t;
	typedef sdPCI::known_class_t known_class_t;
	void setBaseClassBasedLoadConfig  (const std::string& class_substr, load_config_t config);
	void setSubClassBasedLoadConfig   (const std::string& class_substr, load_config_t config);
	void setKnownClassBasedLoadConfig (known_class_t known_class, load_config_t config);
	void detect(ModuleLoader& loader, bool devices_loaded = false);
public:
	void showDetectedDevices(std::ostream& stream) const;
	void getDetectedDevices(std::vector<DetectedDevicePCI>& result) const;
private:
	PCIIDs m_ids;
	PCIMap m_map;
private:
	typedef std::pair<std::string, load_config_t> pattern_config_t;
	typedef std::list<pattern_config_t> configured_list_t;
	configured_list_t m_base_class_config;
	configured_list_t m_sub_class_config;

	class isMatchPattern : public std::unary_function<const pattern_config_t&, bool> {
	public:
		isMatchPattern(const std::string& pattern) : m_pattern(pattern) {}
		~isMatchPattern() {}
	private:
		const std::string& m_pattern;
	public:
		bool operator() (const pattern_config_t& config) const
		{
			if( config.first.find(m_pattern) != std::string::npos ) {
				return true;
			} else {
				return false;
			}
		}
	};

	load_config_t detLoadConfig(
			const configured_list_t& configured_list,
			const std::string* p_pattern
			) const;

	typedef std::map<known_class_t, load_config_t> known_class_config_map_t;
	known_class_config_map_t m_known_class_config;
private:
	typedef uint64_t pci_id_t;
	typedef std::map<pci_id_t, PCIDevice> devices_t;
	devices_t m_devices;
private:
	void loadDevices(void);
	void loadModules(ModuleLoader& loader, const PCIDevice& device) const;
private:
	sdPCIIMPL();
};


}  // namespace SimpleDetect

#endif /* sdpci_impl.h */
