#ifndef __SDUSB_IMPL_H_INCLUDED
#define __SDUSB_IMPL_H_INCLUDED 1

#include "sdusb.h"
#include "usbids.h"
#include "usbmap.h"
#include <list>
#include <map>
#include <functional>

namespace SimpleDetect {


struct USBDevice {
	USBIDTypes::Vendor::id_type vendor_id;
	USBIDTypes::Device::id_type device_id;
	// USBIDTypes::SubVendor::id_type subvendor_id;
	// USBIDTypes::SubDevice::id_type subdevice_id;
	USBIDTypes::BaseClass::id_type baseclass_id;
	USBIDTypes::SubClass::id_type  subclass_id;
	std::string manufacturer;
	std::string product_name;
	std::list<std::string> modules;
	bool loaded;
};


class sdUSBIMPL {
public:
	sdUSBIMPL(const std::string& ids_path, const std::string map_path);
	~sdUSBIMPL();
public:
	void initialize(void);
public:
	typedef sdUSB::load_config_t load_config_t;
	typedef sdUSB::known_class_t known_class_t;
	void setBaseClassBasedLoadConfig  (const std::string& class_substr, load_config_t config);
	void setSubClassBasedLoadConfig   (const std::string& class_substr, load_config_t config);
	void setKnownClassBasedLoadConfig (known_class_t known_class, load_config_t config);
	void detect(ModuleLoader& loader, bool devices_loaded = false);
public:
	// for debug
	void showDetectedDevices(std::ostream& stream) const;
private:
	USBIDs m_ids;
	USBMap m_map;
private:
	typedef std::pair<std::string, load_config_t> pattern_config_t;
	typedef std::list<pattern_config_t> configured_list_t;
	configured_list_t m_base_class_config;
	configured_list_t m_sub_class_config;

	class isMatchPattern : public std::unary_function<const pattern_config_t&, bool> {
	public:
		isMatchPattern(const std::string& pattern) : m_pattern(pattern) {}
		~isMatchPattern() {}
	private:
		const std::string& m_pattern;
	public:
		bool operator() (const pattern_config_t& config) const
		{
			if( config.first.find(m_pattern) != std::string::npos ) {
				return true;
			} else {
				return false;
			}
		}
	};

	load_config_t detLoadConfig(
			const configured_list_t& configured_list,
			const std::string* p_pattern
			) const;

	typedef std::map<known_class_t, load_config_t> known_class_config_map_t;
	known_class_config_map_t m_known_class_config;
private:
	typedef uint64_t usb_id_t;
	typedef std::map<usb_id_t, USBDevice> devices_t;
	devices_t m_devices;
private:
	void loadDevices(void);
	void loadModules(ModuleLoader& loader, const USBDevice& device) const;
private:
	sdUSBIMPL();
};


}  // namespace SimpleDetect

#endif /* sdusb_impl.h */
