#include "shadowmapper.h"
#include "process.h"
#include "constant.h"
#include "display.h"
#include "exception.h"

namespace VIVER {


// 定数
const char* ShadowMapper::KERNEL_MODULE("cowloop");


// コンストラクタ
ShadowMapper::ShadowMapper(DeviceManager& _devmanager, const DeviceNode* const rdonly_node, const Path& shadow_path, const std::string& fstype, unsigned long mount_flags, const std::string& data_string) :
	devmanager(_devmanager),
	m_p_rdonly_node(rdonly_node),
	m_shadow_path(shadow_path),
	m_fstype(fstype),
	m_mount_flags(mount_flags),
	m_data_string(data_string)
{}


// デストラクタ
ShadowMapper::~ShadowMapper()
{}


// public:
DeviceNode* ShadowMapper::form(void)
{
	// TODO: この関数のコードはcowloopに依存

	// /dev/cow/ctl はあらかじめ作成しておく
	// FileSystem::makeDirForce("/dev/cow");
	// FileSystem::makeBlockNodeForce("/dev/cow/ctl", 241, 255);

	DeviceNode* dn_cow = devmanager.requestNode(241,0,"cow0",m_fstype,m_mount_flags,m_data_string);
	if( dn_cow->makeNode() < 0 ) {
		throw NoSuchFileError(CANNOT + "make device node " + dn_cow->getNodePath().str() + errorDescribe() );
	}


	// 既にm_shadow_pathが存在したら、cowrepairを実行する
	FileSystem::file_type ft;
	ft = FileSystem::checkFileExists( m_shadow_path );
	if( ft == FileSystem::REGULAR_FILE ) {
		// ファイルが存在
		Process ps_cowrepair(Component::Program::COWREPAIR);
		ps_cowrepair % m_shadow_path.c_str();
		MultiPipe mp_cowrepair( ps_cowrepair.exec(true,true), host::display.verbose(), host::display.notice() );
		mp_cowrepair.display();
		ps_cowrepair.wait();
	} else if( ft != FileSystem::NOT_EXISTS ) {
		// ディレクトリやFIFOなどが存在
		throw NoSuchFileError(
				CANNOT + "make shadow file " + m_shadow_path.str()
				+ ", directory or special file exist."
			);
	}
		// 何も存在しなければ続行


	Process ps_cowdev(Component::Program::COWDEV);
	ps_cowdev % "-a" % m_p_rdonly_node->getNodePath().c_str() % m_shadow_path.c_str() % dn_cow->getNodePath().c_str();
	MultiPipe mp_cowdev( ps_cowdev.exec(true,true), host::display.debug(), host::display.warn() );
	mp_cowdev.display();

	if( ps_cowdev.wait() != 0 ) {
		throw ExecuteFailedError("Can't form Copy-on-Write device");
	}

	return dn_cow;
}


}  // namespace VIVER

