#ifndef __SHADOWMAPPER_H_INCLUDED
#define __SHADOWMAPPER_H_INCLUDED 1

#include "parameters.h"
#include "devicemanager.h"
#include "path.h"
#include <string>

namespace VIVER {


class ShadowMapper {
public:
	ShadowMapper(DeviceManager& _devmanager, const DeviceNode* const rdonly_node, const Path& shadow_path, const std::string& fstype, unsigned long mount_flags, const std::string& data_string);
			// throw()
	~ShadowMapper();	// throw()
public:
	DeviceNode* form(void);	// throw(NoSuchFileError, ExecuteFailedError)
public:
	static const char* KERNEL_MODULE;
private:
	DeviceManager& devmanager;
	const DeviceNode* m_p_rdonly_node;
	const Path m_shadow_path;
	const std::string m_fstype;
	unsigned long m_mount_flags;
	std::string m_data_string;
private:
	ShadowMapper();				// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* shadowmapper.h */
