#ifndef __SHARED_BLOCK_H_INCLUDED
#define __SHARED_BLOCK_H_INCLUDED 1

#include "devicemanager.h"
#include "parameters.h"
#include "exception.h"
#include <string>
#include <boost/utility.hpp>

namespace VIVER {


// 例外
VIVER_MakeRuntimeError( SBDConnectFailedError );


class SharedBlockDevice : private boost::noncopyable {
public:
	explicit SharedBlockDevice(const Parameters& _parameters, DeviceManager& _devmanager);	// throw()
	~SharedBlockDevice();	// throw()
public:
	void configure(void);	// throw()
	DeviceNode* connect(const std::string& fstype,
			unsigned long mount_flags, const std::string& data_string);
				// throw(FileSystemError, ExecuteFailedError, SBDConnectFailedError);
	void disconnect(void);	// throw(ExecuteFailedError)
public:
	static const std::string KERNEL_MODULE;
private:
	const Parameters& parameters;
	DeviceManager& devmanager;
	DeviceNode* m_dn_nbd;
	std::string m_bootstrap_ip;
	std::string m_bootstrap_port;
private:
	SharedBlockDevice();			// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* sharedblock.h */
