#include "union_buffer.h"
#include "exception.h"

namespace VIVER {


// コンストラクタ
UnionStreamBuffer::UnionStreamBuffer()
{
	setInitialPointers();
}


// public:
UnionStreamBuffer::WriterID UnionStreamBuffer::addWriter(WriterFunction writer_func)
{
	m_writers.push_back(writer_func);
	return --(m_writers.end());
}

void UnionStreamBuffer::removeWriter(WriterID& id)
{
	// FIXME: 例外処理を未実装？ list::erase()は例外を投げない？
	m_writers.erase(id);
}

int UnionStreamBuffer::sync()
{
	*pptr() = '\0';
	for( std::list<WriterFunction>::iterator fout=m_writers.begin();
			fout != m_writers.end();
			++fout ) {
		(*fout)(m_buffer);
	}
	pbump( pbase() - pptr() );
	return 0;
}


// private:
inline void UnionStreamBuffer::setInitialPointers(void)
{
	char *buf_start = m_buffer;
	char *buf_end   = m_buffer + buffer_size;
	setp(buf_start, buf_end);
	setg(buf_start, buf_start, buf_end);
}


}  // namespace VIVER
