#ifndef __USBIDS_H_INCLUDED
#define __USBIDS_H_INCLUDED 1

#include "usbids_types.h"

namespace SimpleDetect {


class USBIDs {
public:
	USBIDs(const std::string& usbids_path);
	~USBIDs();
public:
	void load(void);
public:
	const std::string* getVendorName(USBIDTypes::Vendor::id_type id) const;
	const std::string* getDeviceName(USBIDTypes::Vendor::id_type vendor_id, USBIDTypes::Device::id_type device_id) const;
	const std::string* getBaseClassName(USBIDTypes::BaseClass::id_type id) const;
	const std::string* getSubClassName(USBIDTypes::BaseClass::id_type base_id, USBIDTypes::SubClass::id_type sub_id) const;
private:
	std::string m_ids_path;
	USBIDTypes::VendorDeviceMap m_idmap;
	USBIDTypes::ClassMap m_classmap;
private:
	USBIDs();
};


}  // namespace SimpleDetect

#endif /* usbids.h */
