#include "virtualdevice.h"
#include "exception.h"

namespace VIVER {


// コンストラクタ
VirtualDevice::VirtualDevice(const std::string& target_name,
		const std::string& fstype, unsigned long mount_flags, const std::string& data_string) :
	Mountable(fstype, mount_flags, data_string),
	m_target_name(target_name)
{}


// デストラクタ
VirtualDevice::~VirtualDevice()
{}


// public:
void VirtualDevice::mount(const Path& mount_point)
{
	if( m_mounted ) {
		// 既にマウントされているので move
		return move(mount_point);
	}

	Mountable::mount(m_target_name, mount_point.str(), m_fstype,
			m_mount_flags, m_data_string);
	m_mounted = true;
	m_mount_point = mount_point;
}

void VirtualDevice::umount(void)
{
	// マウントされていなくても続行。Mountable::umount()の中で例外が発生する。
	Mountable::umount( m_mount_point.str() );
	m_mounted = false;
}

void VirtualDevice::move(const Path& mount_point)
{
	// マウントされていなくても続行
	Mountable::move(m_mount_point.str(), mount_point.str());
	m_mount_point = mount_point;
}

void VirtualDevice::remount(unsigned long mount_flags, const std::string& data_string)
{
	// マウントされていなくても続行
	Mountable::remount(m_target_name, m_mount_point.str(), mount_flags, data_string);
	m_mount_flags = mount_flags;
	m_data_string = data_string;
}

void VirtualDevice::remount(const std::string& hand_options)
{
	// マウントされていなくても続行
	std::pair<unsigned long, std::string> opt( Mountable::splitHandOptions(hand_options) );
	Mountable::remount(m_target_name, m_mount_point.str(), opt.first, opt.second);
	m_mount_flags = opt.first;
	m_data_string = opt.second;
}


}  // namespace VIVER
