#ifndef __VIRTUAL_DEVICE_H_INCLUDED
#define __VIRTUAL_DEVICE_H_INCLUDED 1

#include "mountable.h"

namespace VIVER {


class VirtualDevice : public Mountable {
public:
	// まだマウントしていないVirtualDeviceを作成
	VirtualDevice(const std::string& target_name,
			const std::string& fstype, unsigned long mount_flags, const std::string& data_string);
		// throw()

	// 既にマウント済みのVirtualDeviceは作成できない

	~VirtualDevice();	// throw()
public:
	// Mountableインターフェース
	void mount(const Path& mount_point);		// throw(MountError)
	void umount(void);				// throw(MountError)
	void move(const Path& mount_point);		// throw(MountError)
	void remount(unsigned long mount_flags, const std::string& data_string);	// throw(MountError)
	void remount(const std::string& hand_options);	// throw(MountError)
public:
	const std::string& getTargetName(void) const { return m_target_name; }		// throw()
private:
	std::string m_target_name;
private:
	VirtualDevice();				// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* virtual_device.h */
