#include "controler.h"
#include "color.h"
#include "fallback.h"
#include <iostream>
#include <functional>
#include <pthread.h>
#include <boost/bind.hpp>

// for debug mode
#include "display.h"
#include "constant.h"
#include "csv.h"
#include "shell.h"
#include <set>
#include <string>

using namespace VIVER;

#define VIVER_CL_CALL(func) fallback.toShell( boost::bind(&Controler::func, &cl, _1) )

namespace {
std::set<std::string> break_points;
void parseBreakPoints(const char* param);
void breakPoint(const std::string& point);
}  // noname namespace


int main(int argc, char* argv[])
{
	// バナー表示
	std::cout
		<< Color::YELLOW << "Starting "
		<< Color::GREEN  << "VIVER "
		<< Color::YELLOW << VERSION
		<< std::endl;

	Controler cl;
	FallBack fallback;

	VIVER_CL_CALL( initial			);

	parseBreakPoints( cl.getParameterString("breakpoint", "") );
	breakPoint("initial");

	VIVER_CL_CALL( mountArk			);	breakPoint("ark");
	VIVER_CL_CALL( startLogd		);	breakPoint("logd");

	VIVER_CL_CALL( newDevmanager		);
	VIVER_CL_CALL( mountModules		);	breakPoint("modules");
	VIVER_CL_CALL( detectHardware		);	breakPoint("sd");
	VIVER_CL_CALL( loadSystemModules	);	breakPoint("modprobe");

	if( cl.isBootFormDisk() ) {
		VIVER_CL_CALL( mountBootDisk		);	breakPoint("bootdisk");
		if( cl.isToRAM() ) {
			VIVER_CL_CALL( mountToRAMFS );			breakPoint("toramfs");
			VIVER_CL_CALL( toRAM );				breakPoint("toram");
			VIVER_CL_CALL( losetupCompressedOnRAM	);	breakPoint("getsquash");
		} else {
			VIVER_CL_CALL( losetupCompressedOnDisk	);	breakPoint("getsquash");
		}
	} else {
		VIVER_CL_CALL( wakeNetwork		);	breakPoint("wakenet");
		VIVER_CL_CALL( connectSBD		);	breakPoint("sbd");
		if( cl.isToRAM() ) {
			VIVER_CL_CALL( mountToRAMFS );			breakPoint("toramfs");
			VIVER_CL_CALL( toRAM );				breakPoint("toram");
			VIVER_CL_CALL( losetupCompressedOnRAM	);	breakPoint("getsquash");
		}
	}
	VIVER_CL_CALL( mountCompressed		);	breakPoint("unsquash");

	if( cl.isRAMScreen() ) {
		VIVER_CL_CALL( configureRAMScreen	);	breakPoint("ram");
	} else {
		VIVER_CL_CALL( mountDirectScreen	);	breakPoint("screen");
		VIVER_CL_CALL( losetupLoopScreen	);	breakPoint("loopscreen");
	}
	VIVER_CL_CALL( mountScreen		);	breakPoint("mountscreen");

	VIVER_CL_CALL( losetupFixed		);	breakPoint("fixed");
	VIVER_CL_CALL( makeSparse		);	breakPoint("sparse");
	VIVER_CL_CALL( connectSparse		);	breakPoint("dmsetup");
	VIVER_CL_CALL( formShadow		);	breakPoint("cowdev");

	VIVER_CL_CALL( mountFormedImage		);	breakPoint("sysroot");
	VIVER_CL_CALL( expandFormedImage	);	breakPoint("growfs");

	VIVER_CL_CALL( umountModuleDisk		);	breakPoint("unmodules");

	VIVER_CL_CALL( switchRoot		);	breakPoint("pivot");

	VIVER_CL_CALL( editSysRoot		);
	VIVER_CL_CALL( outputParameters		);	breakPoint("editfs");

	VIVER_CL_CALL( stopLogd			);	breakPoint("stoplogd");
	VIVER_CL_CALL( rc			);	breakPoint("rc");
	VIVER_CL_CALL( post			);	breakPoint("post");

	// バナー表示
	std::cout
		<< Color::YELLOW << "End "
		<< Color::GREEN  << "VIVER "
		<< Color::YELLOW << VERSION
		<< std::endl;

	breakPoint("finish");
}


namespace {
void parseBreakPoints(const char* param)
{
	for( CSV points( param );
			! points.end();
			++points ) {
		break_points.insert( *points );
	}
}
void breakPoint(const std::string& point)
{
	host::display.debug() << "Break point " << point << std::endl;
	if( break_points.find(point) != break_points.end() ) {
		host::display.error() << "Entering debug mode (" << point << ")" << std::endl;
		Shell sh;
		sh.execShell( (Component::Resource::TEMPORARY_DIR + "debug.cmd").str() );
	}
}
}  // noname namespace
