#ifndef VFIELD_INTERFACE_H__
#define VFIELD_INTERFACE_H__

#include "exception.h"
#include <stdint.h>
#include <boost/scoped_ptr.hpp>
#include <boost/utility.hpp>

namespace VFIELD {


class DataRequest;
class RootStorage;
class EdgeStorage;
class SearchController;
class InterfaceIMPL;
class Interface : private boost::noncopyable {
public:
	Interface(RootStorage& root_storage);
	Interface(EdgeStorage& edge_storage, SearchController& engine);
	~Interface();
public:
	typedef enum {
		FAILED = -1,
		SUCCESS = 1,
	} result_type;
	result_type getData(void* buffer, uint64_t from, uint32_t length);
	uint64_t getImageSize(void);
private:
	boost::scoped_ptr<InterfaceIMPL> impl;
	volatile bool m_end_flag;
};


////
// Exception
//
struct InterfaceInitializeException : public std::runtime_error {
	InterfaceInitializeException(const std::string& message) :
		std::runtime_error(message) {}
};
struct InterfaceInitializeSystemCallException : public SystemCallException {
	InterfaceInitializeSystemCallException(int errno_, const std::string& message) :
		SystemCallException(errno_, message) {}
};


}  // namespace VFIELD

#endif /* interface.h */
