#ifndef VFIELD_RECEPTOR_H__
#define VFIELD_RECEPTOR_H__

#include "notify.h"
#include "request.h"
#include "bufferedreq.h"
#include <utility>
#include <boost/shared_array.hpp>

// XXX: DataReceptor::waitAndCopy()は、waitが失敗したときに例外を投げる

namespace VFIELD {


////
// Exception
//
struct DataLostException : public std::runtime_error {
	DataLostException(const std::string& message) :
		std::runtime_error(message) {}
};


////
// DataReceptor
//
class DataReceptor {
public:
	DataReceptor(const BufferedRequest& source, DataRequest& target);
	~DataReceptor();
public:
	void waitAndCopy(void);			// throw(DataLostException)
public:
	inline std::pair<BufferedRequest, bool> calcUnmatchedBefore(void)
	{
		// +--------- target ----------+
		//                    +----- source -----+
		// +--- unmatched ---+
		if( m_target.start() < m_source.start() ) {
			return std::make_pair(
					BufferedRequest(
						m_target.buffer(),
						m_target.start(),
						m_source.start() - 1
						),
					true
					);
		} else {
			return std::make_pair( BufferedRequest(NULL,0,0), false );
		}
	}
	inline std::pair<BufferedRequest, bool> calcUnmatchedAfter(void)
	{
		//           +--------- target ----------+
		// +----- source -----+
		//                     +--- unmatched ---+
		if( m_source.end() < m_target.end() ) {
			return std::make_pair(
					BufferedRequest(
						m_target.buffer() + (m_source.end() - m_target.start() + 1),
						m_source.end() + 1,
						m_target.end()
						),
					true
					);
		} else {
			return std::make_pair( BufferedRequest(NULL,0,0), false );
		}
	}
private:
	BufferedRequest m_source;	// BufferedRequest内のshared_arrayとNotifyTrigerの所有権を取得
	DataRequest m_target;
};


}  // namespace VFIELD

#endif /* receptor.h */
