require "log"

# pciids: http://pciids.sf.net/pci.db
# usbids: http://www.linux-usb.org/usb.ids
# sysmap: /boot/*ystem*

class HardwareDetect


	def sourcePCI
		if !@pciids_v.empty?
			return
		end

		# pciidsをロード
		File.open(@pcidb_file, "r") {|file|
			# col[0]  col[1]        col[2]                    col[3]
			# v       001c    PEAK-System Technik GmbH        0
			# d       001c0001        PCAN-PCI CAN-Bus controller     0
			file.each {|line|
				begin
					col = line.split("\t")
					case (col[0])
					when "v"
						if col[3] != "0"; next; end
						@pciids_v[ col[1] ] = col[2]
					when "d"
						@pciids_d[col[1][4,4]] = col[2]
					#when "s"
					# subvendor/subdeviceまでは不要
					end
				rescue
					$log.debugError "invalid pciids line: #{line}"
				end
			}
		}

		# pcimapをロード
		File.open(@kmodule.pcimap_file, "r") {|file|
			file.gets # 最初の行はコメントなので飛ばす
			file.each {|line|
				# col[0]               col[1]     col[2]     col[3]     col[4]     col[5]     col[6]     col[7]
				# pci module           vendor     device     subvendor  subdevice  class      class_mask driver_data
				# snd-ymfpci           0x00001073 0x00000004 0xffffffff 0xffffffff 0x00000000 0x00000000 0x0
				begin
					col = line.split(" ")
					if col[1] === "0xffffffff" && col[2] == "0xffffffff"
						# class
						key = col[5][4,4]
						if @pcimap_c.key?(key)
							@pcimap_c[key].push( col[0] )
						else
							@pcimap_c[key] = [ col[0] ]
						end
					elsif col[2] === "0xffffffff"
						# vendor
						key = col[1][6,4]
						if @pcimap_v.key?(key)
							@pcimap_v[key].push( col[0] )
						else
							@pcimap_v[key] = [ col[0] ]
						end
					else
						# vendor + device
						key = col[1][6,4] + col[2][6,4]
						if @pcimap_vd.key?(key)
							@pcimap_vd[key].push( col[0] )
						else
							@pcimap_vd[key] = [ col[0] ]
						end
					end
				rescue
					$log.debugError "invalid pcimap line: #{line}"
				end
			}
		}
	end
	private :sourcePCI




	def sourceUSB
		if !@usbids_v.empty?
			return
		end

		# usbidsをロード
		File.open(@usbids_file, "r") {|file|
			file.each {|line|
				begin
					last_vendor = ""
					if line[0,1] =~ /[0-9a-f]/
						# vendor
						# 0386  LTS
						last_vendor = line[0,4]
						@usbids_v[last_vendor] = line[6..-1].strip	# 改行を取り除く
					elsif line[0,1] === "\t"
						# device
						#         0001  PSX for USB Converter
						if last_vendor.empty?; next; end
						@usbids_vd[ last_vendor + line[1,4] ] = line[7..-1].strip
					else
						# それ以外
						last_vendor = ""
					end
				rescue
					$log.debugError "invalid usbids line: #{line}"
				end
			}
		}

		File.open(@kmodule.usbmap_file, "r") {|file|
			file.gets # 最初の行はコメントなので飛ばす
			file.each {|line|
				begin
					col = line.split(" ")
					# col[0]:  usb module
					# col[2]:  idVendor
					# col[3]:  idProduct
					# col[6]:  bDeviceClass
					# col[7]:  bDeviceSubClass
					# col[8]:  bDeviceProtocol
					# col[9]:  bInterfaceClass
					# col[10]: bInterfaceSubClass
					# col[11]: bInterfaceProtocol
					if col[2] == "0x0000" && col[3] == "0x0000" \
							&& col[6] == "0x00" && col[7] == "0x00" && col[8] == "0x00" \
							&& col[9] != "0x00"
						# interface class
						key = col[9][2,2]
						if @usbmap_ic.key?(key)
							@usbmap_ic[key].push( col[0] )
						else
							@usbmap_ic[key] = [ col[0] ]
						end
					elsif col[2] != "0x0000"
						# vendor + device
						key = col[2][2,4] + col[3][2,4]
						if @usbmap_vd.key?(key)
							@usbmap_vd[key].push( col[0] )
						else
							@usbmap_vd[key] = [ col[0] ]
						end
					end
				rescue
					$log.debugError "invalid usbmap line: #{line}"
				end
			}
		}
	end
	private :sourceUSB


end



$log.debug "#{File.basename(__FILE__, ".*")} loaded"
