# fs_initrd.rb
require "log"
require "dynpath"
require "fsutils"
require "vfs"
require "process"


class InitrdFS < VFS
	def mounted(arg)
		@point = DynamicPath.new(arg)
	end

	#######
	## File
	##
	def mp_proc
		return @point + "/proc"
	end
	def mp_sys
		return @point + "/sys"
	end
	def mp_ark
		return @point + "/VIVER"
	end
	def mp_sysroot
		return @point + "/sysroot"
	end

	def dev
		return @point + "/dev"
	end

	def kmodule_image
		return @point + "/modules.squash"
	end
	def mp_kmodule
		return @point + "/lib/modules"
	end

	def pcidb_file
		return @point + "/usr/pci.db"
	end
	def usbids_file
		return @point + "/usr/usb.ids"
	end

	def dhcp_script
		return @point + "/usr/dhcp-script"
	end
	def zcip_script
		return @point + "/usr/zcip-script"
	end

	def resolvconf
		return @point + "/etc/resolv.conf"
	end

	def vfield_file
		return @point + "/bin/vfield"
	end
	def nbdclient_file
		return @point + "/bin/nbd-client"
	end

	def mktree
		# あらかじめ作っておく
	end


	######
	## Command
	##
	def cmd_mknod(path, b_or_c, major, minor)
		cmd = @point + "/bin/mknod"
		return executeOrRaise(cmd, path, b_or_c, major, minor)
	end
	def cmd_modprobe(mod, option)
		cmd = @point + "/bin/modprobe"
		return executeOrRaise(cmd, mod, option)
	end
	def cmd_mount(args)
		cmd = @point + "/bin/mount"
		return executeOrRaise(cmd, args)
	end
	def cmd_umount(point)
		cmd = @point + "/bin/umount"
		return executeOrRaise(cmd, point)
	end
	def cmd_uname(arg1)
		cmd = @point + "/bin/uname"
		return executeOrRaise(cmd, arg1)
	end
	def cmd_losetup(loop_path, image)
		cmd = @point + "/bin/losetup"
		return executeOrRaise(cmd, loop_path, image)
	end
	def cmd_losetup_d(loop_path)
		cmd = @point + "/bin/losetup"
		return executeOrRaise(cmd, "-d", loop_path)
	end
	def cmd_ip(args)
		cmd = @point + "/bin/ip"
		return executeOrRaise(cmd, args)
	end
	def cmd_ifconfig(args)
		cmd = @point + "/bin/ifconfig"
		return executeOrRaise(cmd, args)
	end
	def cmd_route(args)
		cmd = @point + "/bin/route"
		return executeOrRaise(cmd, args)
	end
	def cmd_zcip(args)
		cmd = @point + "/bin/zcip"
		return executeOrRaise(cmd, args)
	end
	def cmd_udhcpc(args)
		cmd = @point + "/bin/udhcpc"
		return executeOrRaise(cmd, args)
	end
	def chroot_file
		return @point + "/bin/chroot"
	end
	def cmd_chroot(root, relative_cmd,  args)
		cmd = @point + "/bin/chroot"
		return executeOrRaise(cmd, root, relative_cmd, args)
	end

	def exec_switch_root(new_root, new_init)
		Kernel.exec("#{@point}/bin/switch_root", new_root.to_s, new_init)
	end

end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"

