#ifndef VFIELD_LOG_H__
#define VFIELD_LOG_H__

#include "asynclog.h"
#include <exception>
#include <stdexcept>

namespace VFIELD {

namespace Log {


#define LogDebug0(msg) \
	try {												\
		Log::asynclog_->write<AsyncLog::ASLOG_DEBUG>(						\
				Log::format("%1% (%2%): %3%") % __FILE__ % __LINE__ % (msg)		\
				);									\
	} catch (const std::runtime_error& ex) {							\
		Log::asynclog_->write<AsyncLog::ASLOG_ERR>(						\
				Log::format("%1% (%2%): LogError: ") % __FILE__ % __LINE__ % ex.what()	\
				);									\
	} catch (...) {											\
		Log::asynclog_->write<AsyncLog::ASLOG_ERR>(						\
				Log::format("%1% (%2%): LogError") % __FILE__ % __LINE__		\
				);									\
	}												\

#define LogDebug(msg)  \
	try {												\
		Log::asynclog_->write<AsyncLog::ASLOG_DEBUG>(						\
				Log::format("%1% (%2%): %3%") % __FILE__ % __LINE__ % (msg)		\
				);									\
	} catch (const std::runtime_error& ex) {							\
		Log::asynclog_->write<AsyncLog::ASLOG_ERR>(						\
				Log::format("%1% (%2%): LogError: ") % __FILE__ % __LINE__ % ex.what()	\
				);									\
	} catch (...) {											\
		Log::asynclog_->write<AsyncLog::ASLOG_ERR>(						\
				Log::format("%1% (%2%): LogError") % __FILE__ % __LINE__		\
				);									\
	}												\

#define LogDebugError(msg)  \
	try {												\
		Log::asynclog_->write<AsyncLog::ASLOG_INFO>(						\
				Log::format("%1% (%2%): %3%") % __FILE__ % __LINE__ % (msg)		\
				);									\
	} catch (const std::runtime_error& ex) {							\
		Log::asynclog_->write<AsyncLog::ASLOG_ERR>(						\
				Log::format("%1% (%2%): LogError: ") % __FILE__ % __LINE__ % ex.what()	\
				);									\
	} catch (...) {											\
		Log::asynclog_->write<AsyncLog::ASLOG_ERR>(						\
				Log::format("%1% (%2%): LogError") % __FILE__ % __LINE__		\
				);									\
	}												\


#define LogInfo(msg)   (Log::asynclog_->write<AsyncLog::ASLOG_NOTICE>(msg))
#define LogWarn(msg)   (Log::asynclog_->write<AsyncLog::ASLOG_WARNING>(msg))
#define LogError(msg)  (Log::asynclog_->write<AsyncLog::ASLOG_ERR>(msg))


#ifdef NDEBUG
#undef  LogDebug
#undef  LogDebug0
#undef  LogDebugError
#define LogDebug(msg)      ((void)0)
#define LogDebug0(msg)     ((void)0)
#define LogDebugError(msg) ((void)0)
#endif  /* NDEBUG */

#ifdef QUIET
#undef  LogDebug
#undef  LogDebug0
#define LogDebug(msg)      ((void)0)
#define LogDebug0(msg)     ((void)0)
#endif /* QUIET */

#ifdef QUIET0
#undef  LogDebug0
#define LogDebug0(msg)     ((void)0)
#endif /* QUIET0 */



typedef AsyncLog::format format;

extern AsyncLog* asynclog_;

struct LogInitializer {
	LogInitializer();
	~LogInitializer();
};


}  // namespace Log

}  // namespace VFIELD

#endif /* log.h */
