#ifndef VFIELD_RPCSERVER_H__
#define VFIELD_RPCSERVER_H__

#include "exception.h"
#include <boost/utility.hpp>
#include <boost/scoped_ptr.hpp>

namespace VFIELD {


// XXX: image_idの処理が無い


class RPCServerIMPL;
class StreamManager;
class VTable;
class Storage;
class SearchController;
class NodeIdentity;
class ThreadPool;
class RPCServer {
public:
	RPCServer(	const NodeIdentity& self_identity,
			StreamManager& smgr,
			VTable& vtable,			// rpcNotify*を配分
			Storage& storage,		// rpcFindを配分
			SearchController& engine,	// rpcNotifyUpを配分
			ThreadPool& threadpool	);	// throw( RPCListenException )
	~RPCServer();
public:
	const NodeIdentity& getSelfIdentity(void) const;
public:
	// for Storage
	//void setImageId(uint16_t image_id);
private:
	boost::scoped_ptr<RPCServerIMPL> impl;
private:
	RPCServer();
};


////
// Exception
//
struct RPCListenException : public SystemCallException {
	RPCListenException(int errno_, const std::string& message) :
		SystemCallException(errno_, message) {}
};


}  // namespace VFIELD

#endif /* rpcserver.h */
