#ifndef VFIELD_FINALIZER_H__
#define VFIELD_FINALIZER_H__

#include <boost/function.hpp>

namespace VFIELD {


class Finalizer {
public:
	Finalizer(const boost::function<void (void)>& func) : m_func(func) {}
	~Finalizer() { m_func(); }
public:
	void swapFunc(const boost::function<void (void)>& func) { m_func = func; }
private:
	boost::function<void (void)> m_func;
private:
	Finalizer();
};


}  // namespace VFIELD

#endif /* finalizer.h */
