#include "vtable.h"
#include "stream/stream.h"
#include "rpc/rpcclient.h"
#include "rw_lock.h"
#include "stdext_hash_map.h"
#include "node_hash.h"
#include "log.h"
#include <algorithm>
#include <iterator>

namespace VFIELD {


////
// VTableIMPL
//
class VTableIMPL : private boost::noncopyable {
friend class VTableEach;
public:
	VTableIMPL(RPCClient& rpcc);
	~VTableIMPL();
public:
	typedef VTable::duplex_type  duplex_type;
	inline void calcDuplex(pos_type image_size, duplex_type& result) const;
public:
	inline void strippedNodeDownDetect(const StrippedNodeIdentity& down_node);
public:
	inline void rpcNotifyUp(const NodeIdentity& up_node, const DataRange& up_range);
	inline void rpcNotifyDown(const NodeIdentity& down_node, StreamManager& smgr);
	inline void rpcPing(const NodeIdentity& up_node);
public:
	void setImageSize(pos_type size);
	void streamJoin(AutoSock& asock, uint16_t image_id, uint64_t image_size);
public:
	void changeRandomizeSeed(void);
public:
	// std::listのイテレータは、insertやeraseで無効化されない
	typedef std::list< std::pair<DataRange, NodeIdentity> > table_type;
	typedef stdext::hash_map<NodeIdentity, table_type::iterator, NodeIdentityHash> exist_type;
private:
	mutable rw_mutex m_table_mutex;
	table_type m_table;
	boost::mutex m_exist_mutex;
	exist_type m_exist;

	pos_type m_image_size;		// m_image_sizeを超過したrpcNotifyUpは無視する

	RPCClient& m_rpcc;

	unsigned int m_randomize_seed;		// TODO: size_t > unsigned int なので、ノード数がunsigned intの最大値を越えると正しくランダムにならない
private:
	VTableIMPL();
};



class VTableEach {
public:
	VTableEach(VTable& vtable) : m_vtable(vtable) {}
public:
	template<typename Function> void match(Function callback) {
		VTableIMPL::table_type& table(m_vtable.impl->m_table);

		// m_tableをreadロック
		scoped_read_lock lk_table_r(m_vtable.impl->m_table_mutex);

		VTableIMPL::table_type::iterator start( table.begin() );
		int random = m_vtable.impl->m_randomize_seed % table.size();
		std::advance(start, random);	// FIXME: これは重いのかもしれない

		LogDebug0( Log::format("VTable randamized advance: %1%") % random );
		std::for_each(start, table.end(), callback);
		std::for_each(table.begin(), start, callback);

		// m_tableをアンロック
	}
private:
	VTable& m_vtable;
};


}  // namespace VFIELD
